# $Id: Request.pm 34881 2011-05-23 18:31:11Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Request::Error;

use Xyzzy::Document::XHTML -self;

field type;
field args;

sub build {
	my $root = $self->construct($self->type);
	$self->setDocumentElement($root);
	my $args = $self->args;
	while(my ($key, $val) = each(%$args)) {
		$root->appendTextChild($key, "$val");
	}
	eval { $self->transform('error') };
	warn $@ if $@;
}

package Aselect::Request;

use Xyzzy::Request -self;

field dir => sub { shift->cfg->dir };
field gssapi => sub { shift->cfg->gssapi };
field crypto => sub { shift->cfg->crypto };

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

field lang => sub {
	my $self = shift;

	my @supported = @{$self->cfg->languages};
	return undef unless @supported;
	my %supported; @supported{@supported} = ();

	if(my $lang = $self->cookie('lang')) {
		foreach my $preferred (split(qr{\s*/\s*}, lc($lang))) {
			return $preferred if exists $supported{$preferred};
		}
	}

	my $h = lc($self->http('Accept-Language'));
	$h =~ s/\s//g;

	my $curlang = $supported[0];
	my $curlevel = 0;

	foreach my $q (split(',', $h)) {
		my $level = 1;
		my ($lang, @attrs) = split(';', $q);
		$lang =~ s/-.*//;
		next unless exists $supported{$lang};
		foreach my $a (@attrs) {
			my ($key, $val) = split('=', $a, 2);
			next unless $key eq 'q';
			next unless defined $val;
			next unless $val =~ /^\d+(?:\.\d+)?$/;
			$level = $val;
		}
		if($level > $curlevel) {
			$curlang = $lang;
			$curlevel = $level;
		}
	}

	return $curlang;
};

sub error {
	my ($type, $exc, %args) = @_;
	die $exc if ref $exc;
	warn $exc if $exc;
	my $doc = new Aselect::Request::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}
