# $Id: Logout.pm 34309 2011-03-23 16:29:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Logout.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Logout::Request;

use Aselect::Session;
use Aselect::Session::Request -self;

param url => sub { $_ //= (shift->script_url . '/') };
param nonce => sub {
	my $self = shift;
	my @nonce = eval { $self->crypto->check_token('n'.$self->session, $_, $self->cfg->request_timeout) };
	$_ = @nonce > 0;
};

sub confirmation_required {
	return $self->session && $self->nag && !$self->nonce;
}

package Aselect::Logout::Success;

use Aselect::Document -self;

sub build {
	$self->setDocumentElement($self->construct('logout-success',
		['return-link', $self->req->bare_url]
	));
}

sub response {
	my $res = super;

	my $cfg = $self->cfg;
	my $cookie = $self->bakecookie(session => '');
	if(my $domain = $cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	$cookie->expire(0);
	$res->setcookie($cookie);

	return $res;
}

package Aselect::Logout::Confirm;

use Aselect::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct('confirm-logout' =>
		[nonce => scalar $req->crypto->create_token('n'.$req->session)]
	);
	$self->setDocumentElement($root);

	if(my $url = $req->bare_url) {
		$root->appendTextChild(url => $url);
	}

	if($req->nag) {
		$root->appendTextChild(warn => 'true');
	}
}

package Aselect::Logout;

use Aselect::Handler -self;

field methods;

sub handle {
	my $req = new Aselect::Logout::Request(cfg => $self, ctx => shift);
	my $doc = $req->confirmation_required
		? new Aselect::Logout::Confirm(req => $req)
		: new Aselect::Logout::Success(req => $req);
	return $doc->response;
}
