use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Document;

use Xyzzy::Document::XHTML -self;

sub transform {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub build {
	$self->hook_next;
	my $name = $self->xml->documentElement->nodeName;
	$name =~ tr|:|/|;
	eval { $self->transform($name) };
	warn $@ if $@;
}
