# $Id: Request.pm 34594 2011-04-14 07:49:33Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Request.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Request::Error;

use Xyzzy::Document::XHTML -self;

field type;
field args;

sub build {
	my $root = $self->construct($self->type);
	$self->setDocumentElement($root);
	my $args = $self->args;
	while(my ($key, $val) = each(%$args)) {
		$root->appendTextChild($key, "$val");
	}
	eval { $self->transform('error') };
	warn $@ if $@;
}

package Aselect::Request;

use Xyzzy::Request -self;

field dir => sub { shift->cfg->dir };
field gssapi => sub { shift->cfg->gssapi };
field crypto => sub { shift->cfg->crypto };

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

sub error {
	my ($type, $exc, %args) = @_;
	die $exc if ref $exc;
	warn $exc if $exc;
	my $doc = new Aselect::Request::Error(req => $self, type => $type, args => \%args);
	return $doc->response;
}
