# $Id: Password.pm 34595 2011-04-14 08:15:15Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Password.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Password::Request;

use Aselect::Login::Request -self;

param username => sub {
	return unless defined;
	s/\s+//g;
	$_ = lc;
};

param password;

param lt => sub {
	my $self = shift;
	$_ = eval { $self->crypto->check_token('lt', $_, $self->cfg->request_timeout); 1 };
};

param gateway => sub { $_ = defined };

field 'message' => undef;

const uid => sub {
	my $self = shift;

	return undef unless $self->lt;

	my $username = $self->username;
	my $password = $self->password;

	return undef unless $username && $password;

	my $uid = eval { $self->dir->authenticate($username, $password) };
	die $self->error('backend', $@, username => $username) if $@;
	$self->message('credentials') unless $uid;
	return $uid;
};

package Aselect::Password::Document;

use Aselect::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(password =>
		[lt => scalar $req->crypto->create_token('lt')]
	);
	$self->setDocumentElement($root);

	if(my $username = $req->username) {
		$root->appendTextChild(username => $username);
	}

	if(my $message = $req->message) {
		$root->appendTextChild(message => $message);
	}

	if(my $rid = $req->rid) {
		$root->appendTextChild(rid => $rid);
	}

	if(my $service = $req->service) {
		$root->appendTextChild(service => $service);
	}

	if(my $nag = $req->nag) {
		$root->appendTextChild(warn => 'true');
	}
}

sub response {
	my $res = super;
	$res->addheader('Cache-Control' => 'no-store');
	return $res;
}

package Aselect::Password;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Password::Request(cfg => $self, ctx => shift);
	return if $req->gateway;
	my $doc = $req->uid
		? new Aselect::Login::Success(req => $req)
		: new Aselect::Password::Document(req => $req);
	return $doc->response;
}
