# $Id: Giveup.pm 34309 2011-03-23 16:29:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Giveup.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Giveup::Request;

use Aselect::Login::Request -self;

const credentials => 'failed';

package Aselect::Giveup::Document;

use Aselect::Document -self;

sub build {
	$self->setDocumentElement($self->construct(giveup =>
		[url => $self->req->url]
	));
}

sub response {
	my $res = super;

	my $req = $self->req;

	unless($req->nag) {
		$res->status(302);
		$res->setheader(Location => $req->url);
	}

	return $res;
}

package Aselect::Giveup;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Giveup::Request(cfg => $self, ctx => shift);
	my $doc = new Aselect::Giveup::Document(req => $req);
	return $doc->response;
}
