# $Id: Aselect.pm 34381 2011-03-29 09:16:13Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect;

use Xyzzy::Directory;

use Aselect::Cancel;
use Aselect::Logout;
use Aselect::Giveup;
use Aselect::Password;
use Aselect::RequestAuthentication;
use Aselect::Resources;
use Aselect::Server;
use Aselect::Session;
use Aselect::SPNEGO;
use Aselect::Static;
use Aselect::Status;
use Aselect::ValidateCAS;
use Aselect::VerifyCredentials;
use Aselect::Windshield;

use Aselect::LDAP;
use Aselect::GSSAPI;
use Aselect::Crypto;

use Xyzzy -self;
use Aselect::Config -mixin;
use Aselect::LDAP::Config -mixin;
use Aselect::SPNEGO::Config -mixin;
use Aselect::GSSAPI::Config -mixin;
use Aselect::Crypto::Config -mixin;

sub handler {
	my $rsc = new Aselect::Resources(cfg => $self);

	my $server = new Aselect::Server(cfg => $rsc, requests => {
		authenticate => new Aselect::RequestAuthentication(cfg => $rsc),
		verify_credentials => new Aselect::VerifyCredentials(cfg => $rsc),
	});

	my $status = new Aselect::Status(cfg => $rsc);

	my $root = new Xyzzy::Directory(cfg => $rsc,
		handler => $status,
		subdirs => {
			login => new Aselect::Login(cfg => $rsc, methods => [
				new Aselect::Cancel(cfg => $rsc),
				new Aselect::Session(cfg => $rsc),
				new Aselect::SPNEGO(cfg => $rsc),
				new Aselect::Password(cfg => $rsc),
				new Aselect::Giveup(cfg => $rsc),
			]),
			logout => new Aselect::Logout(cfg => $rsc),
			server => $server,
			aselectserver => new Xyzzy::Directory(cfg => $rsc,
				handler => $status,
				subdirs => { server => $server },
			),
			validate => new Aselect::ValidateCAS(cfg => $rsc)
		}
	);
	return new Aselect::Windshield(cfg => $self, handler => $root);
}

__END__

=encoding utf8

=head1 NAME

Aselect – Single Sign On for web applications

=head1 DESCRIPTION

A module for use with the Xyzzy FastCGI framework to deliver
a seamless Single Sign On experience connecting LDAP, Kerberos
(including Microsoft's Active Directory) with A-Select and CAS
aware applications.

=head1 USAGE

Sample configuration file:

	#! /usr/bin/perl /usr/lib/cgi-bin/xyzzy

	# $Id: Aselect.pm 34381 2011-03-29 09:16:13Z wsl $
	# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect.pm $

	Application Aselect

	StylesheetDir /etc/aselect-perl/stylesheets

	LDAPServer ldap://ldap.example.org
	LDAPBase dc=example,dc=org
	LDAPUsername cn=aselect,dc=example,dc=org
	LDAPPassword hunter2
	LDAPCApath /etc/ssl/certs

	KerberosPrincipal HTTP/host.example.org@DOMAIN.EXAMPLE.ORG

	AselectSecret zxnrbl

	AselectServerID sso.example.org
	AselectCookieDomain sso.example.org

	AselectAttributes basic
		uid $uid
		anr $employeeNumber
		mail $mail

	AselectRequestor foobar basic
	AselectRequestor website basic

	AselectAttributes federated
		urn:mace:dir:attribute-def:uid $uid
		urn:mace:dir:attribute-def:employeeNumber $employeeNumber
		urn:mace:dir:attribute-def:mail $mail
		urn:mace:dir:attribute-def:sn $sn
		urn:mace:dir:attribute-def:cn $sn, $gn
		urn:mace:dir:attribute-def:givenName $gn
		urn:mace:dir:attribute-def:eduPersonEntitlement $eduPersonEntitlement
		urn:mace:dir:attribute-def:eduPersonPrincipalName $eduPersonPrincipalName

	AselectRequestor federation federated
