# $Id: Status.pm 34145 2011-03-11 10:56:24Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Status.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Status::Request;

use Aselect::Session;
use Aselect::Session::Request -self;

param app_id;

package Aselect::Status::Welcome;

use Aselect::Document -self;

sub build {
	$self->setDocumentElement($self->construct('welcome'));
}

package Aselect::Status::Document;

use Xyzzy::Util qw(iso8601);

use Aselect::Document -self;

sub build {
	my $req = $self->req;
	my $cfg = $self->cfg;

	my $uid = $req->uid;
	my $exp = $req->exp;

	my $root = $self->construct('status' =>
		[nonce => scalar $req->crypto->create_token('n'.$req->session)],
		[uid => $uid],
		[organization => $cfg->organization],
		[start => iso8601(localtime($exp))],
		[end => iso8601(localtime($exp + $cfg->session_timeout))],
	);
	$self->setDocumentElement($root);

	my $requestors = $cfg->requestors;

	if(my $app_id = $req->app_id) {
		my $requestor = $requestors->{$app_id}
			or die $req->error('app_id', undef, app_id => $app_id);
		$root->appendTextChild('app_id', $app_id);

		my $attributes = $cfg->dir->attributes($uid, $requestor);

		my %attributes;
		while(@$attributes) {
			my $key = shift @$attributes;
			my $val = shift @$attributes;
			push @{$attributes{$key}}, $val;
		}

		my $attrlist = $self->construct('attributes');
		while(my ($key, $values) = each(%attributes)) {
			$attrlist->appendChild($self->construct('attribute',
				[name => $key],
				[values => map {[value => $_]} @$values]
			));
		}
		$root->appendChild($attrlist);
	}

	my @requestors;
	while(my ($key, $val) = each(%$requestors)) {
		my $policy = $val->policy or next;
		push @requestors, $key if %$policy;
	}

	if(@requestors) {
		$root->appendChild($self->construct(requestors =>
			map {[requestor => $_]} @requestors));
	}
}

package Aselect::Status;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Status::Request(cfg => $self, ctx => shift);
	my $doc = $req->uid
		? new Aselect::Status::Document(req => $req)
		: new Aselect::Status::Welcome(req => $req);
	return $doc->response;
}
