# $Id: Cancel.pm 34309 2011-03-23 16:29:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Cancel.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Cancel::Document;

use Xyzzy::Document -self;

# FIXME: check nonce/lt

sub response {
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setheader(Location => $self->req->bare_url);
	return $res;
}

package Aselect::Cancel::Request;

use Aselect::Login;
use Aselect::Login::Request -self;

param cancel;

param lt => sub {
	my $self = shift;
	$_ = eval { $self->crypto->check_token('lt', $_, $self->cfg->request_timeout); 1 };
};

const credentials => 'canceled';

package Aselect::Cancel;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Cancel::Request(cfg => $self, ctx => shift);
	return unless $req->cancel && $req->lt;
	my $doc = new Aselect::Cancel::Document(req => $req);
	return $doc->response;
}
