# $Id: Giveup.pm 34159 2011-03-13 16:58:39Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Giveup.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Giveup::Request;

use Aselect::Login::Request -self;

package Aselect::Giveup::Document;

use Aselect::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(giveup =>
		[url => $req->url]
	);
	$self->setDocumentElement($root);
}

sub response {
	my $res = super;

	my $req = $self->req;

	unless($req->nag) {
		$res->status(302);
		$res->setheader(Location => $req->url);
	}

	return $res;
}

package Aselect::Giveup;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Giveup::Request(cfg => $self, ctx => shift);
	my $doc = new Aselect::Giveup::Document(req => $req);
	return $doc->response;
}
