# $Id: GSSAPI.pm 32380 2010-09-06 14:29:27Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/GSSAPI.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::GSSAPI::Config;

use Xyzzy -self;

field kerberos_principal => sub { die "No KerberosPrincipal configured\n" };

*set_kerberosprincipal = *kerberos_principal;

package Aselect::GSSAPI;

use GSSAPI;

use Clarity -self;

field cfg;

const principal => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	my $status = 'no clue';
	$status = import GSSAPI::Name(my $sname, $cfg->kerberos_principal, GSSAPI::OID::gss_nt_krb5_name)
		or die "gss_import_name: $status";

	$status = GSSAPI::Cred::acquire_cred($sname, GSS_C_INDEFINITE, GSS_C_NO_OID_SET, GSS_C_ACCEPT, my $scred, my $stime, undef)
		or die "gss_acquire_cred: $status";

	return $scred;
};

const context => sub { new GSSAPI::Context };

sub authenticate {
	my $blob = shift;

	my $status = 'no clue';
	my $context = $self->context;
	$status = $context->accept($self->principal, $blob, GSS_C_NO_CHANNEL_BINDINGS, my $gss_client_name, my $out_mech, my $gss_output_token, my $out_flags, my $out_time, my $gss_delegated_cred)
		or die "gss_accept_sec_context: $status";

	$status = $gss_client_name->display(my $tname)
		or die $status;

	my ($uid, $org) = split('@', $tname, 2);

	return $org, $uid;
}
