# $Id: Cancel.pm 34108 2011-03-03 09:57:36Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Cancel.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Cancel::Document;

use Xyzzy::Document -self;

sub response {
	my $status = new Xyzzy::Status(302);
	my $res = $status->response;
	$res->setheader(Location => $self->req->url);
	return $res;
}

package Aselect::Cancel::Request;

use Aselect::Login;
use Aselect::Login::Request -self;

param cancel;

package Aselect::Cancel;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::Cancel::Request(cfg => $self, ctx => shift);
	return unless $req->cancel;
	my $doc = new Aselect::Cancel::Document(req => $req);
	return $doc->response;
}
