# $Id: Aselect.pm 34128 2011-03-05 15:43:30Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect;

use Xyzzy::Directory;

use Aselect::Static;
use Aselect::Status;
use Aselect::Server;
use Aselect::Cancel;
use Aselect::Session;
use Aselect::Password;
use Aselect::SPNEGO;
use Aselect::Logout;
use Aselect::ValidateCAS;
use Aselect::RequestAuthentication;
use Aselect::VerifyCredentials;
use Aselect::Resources;
use Aselect::Windshield;

use Aselect::LDAP;
use Aselect::GSSAPI;
use Aselect::Crypto;

use Xyzzy -self;
use Aselect::Config -mixin;
use Aselect::LDAP::Config -mixin;
use Aselect::GSSAPI::Config -mixin;
use Aselect::Crypto::Config -mixin;

sub handler {
	my $rsc = new Aselect::Resources(cfg => $self);

	my $server = new Aselect::Server(cfg => $rsc, requests => {
		authenticate => new Aselect::RequestAuthentication(cfg => $rsc),
		verify_credentials => new Aselect::VerifyCredentials(cfg => $rsc),
	});

	my $status = new Aselect::Status(cfg => $rsc);

	my $root = new Xyzzy::Directory(cfg => $rsc,
		handler => $status,
		subdirs => {
			login => new Aselect::Login(cfg => $rsc, methods => [
				new Aselect::Cancel(cfg => $rsc),
				new Aselect::Session(cfg => $rsc),
				new Aselect::SPNEGO(cfg => $rsc),
				new Aselect::Password(cfg => $rsc),
			]),
			logout => new Aselect::Logout(cfg => $rsc),
			server => $server,
			aselectserver => new Xyzzy::Directory(cfg => $rsc,
				handler => $status,
				subdirs => { server => $server },
			),
			validate => new Aselect::ValidateCAS(cfg => $rsc)
		}
	);
	return new Aselect::Windshield(cfg => $self, handler => $root);
}
