<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- please enter your password -->
	<xsl:template match="password" mode="title">
		<xsl:text>Password authentication</xsl:text>
	</xsl:template>

	<xsl:template match="password">
		<p>Please enter your username and password to log in.</p>
		<form action="login" method="post">
			<table><tr>
				<td><label for="username">Username:</label></td>
				<td><input id="username" type="text" name="username" value="{username}"/></td>
			</tr><tr>
				<td><label for="password">Password:</label></td>
				<td><input id="password" type="password" name="password"/></td>
			</tr></table>
			<p>
				<button type="submit" name="login" value="1">Login</button>
				<button type="submit" name="cancel" value="1">Cancel</button>
				<button type="submit" name="domain" value="1">Enable domain logon</button>
				<xsl:apply-templates select="lt|rid|service|warn"/>
			</p>
			<xsl:apply-templates select="message"/>
		</form>
	</xsl:template>

	<xsl:template match="lt|rid|service|warn">
		<input type="hidden" name="{name()}" value="{.}"/>
	</xsl:template>

	<xsl:template match="message">
		<p><strong><xsl:value-of select="."/></strong></p>
	</xsl:template>
</xsl:stylesheet>
