# $Id: Request.pm 36089 2011-11-23 19:23:06Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Static/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Static::Request;

use Xyzzy::Static;
use Aselect::UI::Error::HTTP;

use Aselect::UI::Request -self;
use Xyzzy::Static::Request -mixin;

sub error {
	my $doc = new Aselect::UI::Error::HTTP(req => $self, number => shift);
	return $doc->response;
}

sub path_components {
	my $path = super;
	my $lang = $self->lang
		or return $path;
	$path = ['index'] unless @$path;
	return [$lang, @$path];
}
