# $Id: Config.pm 36128 2011-11-30 13:05:49Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Config.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Requestor;

use Clarity -self;

field name;
field policy => undef;
field pubkey => undef;

package Aselect::Config;

use Xyzzy -self;

use Aselect::Crypto;
use Aselect::URL qw(acl_to_re_url);

field id => sub { shift->cookiedomain };
field organization => 'ACME';
field cookiedomain => undef;
field languages => [];

field requestors => {};
field attributes => {};
field session_timeout => 36000;
field request_timeout => 300;
field credential_timeout => 30;
field strict_transport_security => undef;
field login_url => undef;
field urlfilter => sub { qr{^} };
field servicefilter => sub { qr{^} };

*set_aselectserverid = *id;
*set_aselectorganization = *organization;
*set_aselectcookiedomain = *cookiedomain;

sub set_servicefilter {
	my $filter = shift;
	$self->urlfilter(qr{$filter})
		if defined $filter;
	$filter = @_ ? join('|', map { acl_to_re_url($_) } @_) : '^';
	$self->servicefilter(qr{$filter});
}

sub set_aselectlanguages {
	$self->languages([split(' ', $_[0])]);
}

sub set_aselectattributes {
	my $value = shift;
	die "AselectAttributes requires at least one argument\n"
		unless defined $value;
	my $attributes = $self->attributes;
	my %attributes;
	my ($name, @ancestors) = split(' ', $value);
	foreach my $ancestor (@ancestors) {
		die "'$name':  parent policy '$ancestor' does not exist\n"
			unless exists $attributes->{$ancestor};
		%attributes = %{$attributes->{$ancestor}};
	}
	foreach my $attr (@_) {
		my ($key, $val) = split(' ', $attr, 2);
		$attributes{$key} = $val;
	}
	$attributes->{$name} = \%attributes;
}

sub set_aselectrequestor {
	my ($id, $policy) = split(' ', shift, 3);
	my $requestor = new Aselect::Requestor(name => $id);
	if($policy) {
		my $attributes = $self->attributes;
		die "'$id': unknown policy $policy\n"
			unless exists $attributes->{$policy};
		$requestor->policy($attributes->{$policy});
	}
	if(@_) {
		my $pubkey = eval { Aselect::Crypto->pubkey(@_) };
		die "$id: $@" if $@;
		$requestor->pubkey($pubkey);
	}
	$self->requestors->{$id} = $requestor;
}

sub set_aselectsessiontimeout {
	$self->session_timeout($self->parse_time(@_));
}

sub set_aselectrequesttimeout {
	$self->request_timeout($self->parse_time(@_));
}

sub set_aselectcredentialtimeout {
	$self->credential_timeout($self->parse_time(@_));
}

sub set_stricttransportsecurity {
	$self->strict_transport_security(int($self->parse_time(@_)));
}

sub set_aselectloginurl {
	my $url = shift;
	die "Missing URL\n" unless defined $url;
	die "Invalid URL: '$url'\n" unless $url =~ m{^https?://[!-~]+$};
	$self->login_url($url);
}
