# $Id: Password.pm 35898 2011-11-05 11:53:40Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password;

use Aselect::UI::Password::Request;
use Aselect::UI::Login::Success;
use Aselect::UI::Password::Document;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::UI::Password::Request(cfg => $self, ctx => shift);
	return if $req->gateway;
	my $doc = $req->uid
		? new Aselect::UI::Login::Success(req => $req)
		: new Aselect::UI::Password::Document(req => $req);
	return $doc->response;
}
