# $Id: GSSAPI.pm 34368 2011-03-28 13:06:04Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/GSSAPI.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::GSSAPI::Config;

use Xyzzy -self;

field kerberos_principal => sub { die "No KerberosPrincipal configured\n" };

*set_kerberosprincipal = *kerberos_principal;

package Aselect::GSSAPI;

use GSSAPI;

use Clarity -self;

field cfg;

sub checked() {
	my ($name, $status) = @_;
	return if $status;
	return unless defined $status;
	my $generic = $status->generic_message;
	my $specific = $status->specific_message;
	die "[$name] $generic: $specific\n";
}

const principal => sub {
	my $self = shift;
	my $cfg = $self->cfg;

	checked("gss_import_name", GSSAPI::Name->import(my $sname, $cfg->kerberos_principal, GSSAPI::OID::gss_nt_krb5_name));

	return $sname;
};

const credentials => sub {
	my $self = shift;

	checked("gss_acquire_cred", GSSAPI::Cred::acquire_cred($self->principal, GSS_C_INDEFINITE, GSS_C_NO_OID_SET, GSS_C_ACCEPT, my $scred, my $stime, undef));

	return $scred;
};

sub authenticate {
	my $blob = shift;

	my $context = new GSSAPI::Context;
	checked("gss_accept_sec_context", $context->accept($self->credentials, $blob, GSS_C_NO_CHANNEL_BINDINGS, my $gss_client_name, my $out_mech, my $gss_output_token, my $out_flags, my $out_time, my $gss_delegated_cred));

	checked($gss_client_name->display(my $tname));

	my ($uid, $org) = split('@', $tname, 2);

	return $org, $uid;
}
