# $Id: Request.pm 35761 2011-10-12 18:45:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/ValidateCAS/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::ValidateCAS::Request;

use Aselect::UI::Request -self;

param service => sub { die shift->error("Required request parameter 'service' not supplied") unless defined };
param ticket => sub { die shift->error("Required request parameter 'ticket' not supplied") unless defined };
param pgtUrl => sub { 'FIXME' };
param renew => sub { $_ = eval { parse_bool($_) } // defined };

const uid => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $self->crypto;

	my $ticket = $self->ticket;
	my $service = $self->service;

	my (undef, undef, $uid, $renew) = eval { $crypto->check_cas_token('ST', $service, $ticket, $cfg->credential_timeout) };
	if($@) {
		warn "validate: $@";
		return undef;
	}
	
	if($self->renew && !$renew) {
		warn "CAS validation request requested checking that the supplied ticket (uid=$uid) is renewed but it isn't\n";
		return undef;
	}

	return $uid;
};

sub error {
	my $status = new Xyzzy::Status(400, shift);
	return $status->response;
}
