# $Id: Request.pm 35898 2011-11-05 11:53:40Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Request;

use Xyzzy::Util qw(parse_bool);
use Aselect::URL qw(normalize_url valid_http_url);
use Aselect::Util;
use Aselect::UI::Ticket;
use Aselect::UI::Request -self;

param rid => sub {
	my $self = shift;
	if(defined) {
		my $crypto = $self->crypto;
		my (undef, undef, $origin, $id, $url) =
			eval { $crypto->check_token('r', $_, $self->cfg->request_timeout) };
		die $self->error('rid', $@) if $@;
		$self->requestor_origin($origin);
		$self->requestor_id($id);
		$self->requestor_url($url);
	} else {
		$self->requestor_origin(undef);
		$self->requestor_id(undef);
		$self->requestor_url(undef);
	}
};

param service => sub {
	return unless defined;

	my $self = shift;
	my $cfg = $self->cfg;

	$_ = normalize_url($_);
	die $self->error('service')
        unless valid_http_url($_);

	my $re = $cfg->urlfilter;
	die $self->error('service')
		unless $_ =~ $re;

	$re = $cfg->servicefilter;
	die $self->error('service')
		unless $_ =~ $re;
};

param lt => sub {
	my $self = shift;
	$_ = eval { $self->crypto->check_token('lt'.$self->cur_session->token, $_, $self->cfg->request_timeout); 1 };
};

sub create_lt {
	return scalar $self->crypto->create_token('lt'.$self->new_session->token);
}

sub nonce {
	return super || $self->lt;
}

field effective_warn => sub {
	my $self = shift;
	return 'true' if eval { parse_bool($self->param('warn')) };
	return 'false' unless defined $self->rid || defined $self->service;
	return $self->new_warn;
};

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

bool_param renew;
bool_param remember;

field requestor_origin => sub { shift->rid; return };
field requestor_id => sub { shift->rid; return };
field requestor_url => sub { shift->rid; return };

field credentials => sub {
	my $self = shift;
	my $requestor_id = $self->requestor_id or return undef;
	my $uid = $self->uid or return undef;
	return scalar $self->crypto->create_token('c', $requestor_id, $uid);
};

field ticket => sub {
	my $self = shift;
	my $service = $self->service or return undef;
	my $uid = $self->uid or return undef;
	my $renew = $self->renew;
	return scalar $self->crypto->create_cas_token('ST', $service, $uid, $renew // ());
};

field cred_url => sub {
	my $self = shift;
	if(my $rid = $self->rid) {
		my $credentials = $self->credentials or return undef;
		return aselect_url($self->requestor_url, {
			rid => $rid,
			'a-select-server' => $self->server_id,
			aselect_credentials => $credentials,
		});
	} elsif(my $service = $self->service) {
		my $ticket = $self->ticket or return undef;
		return aselect_url($service, {ticket => $ticket});
	} else {
		return $self->script_url . '/status';
	}
};

field bare_url => sub {
	my $self = shift;
	if(my $requestor_url = $self->requestor_url) {
		return $requestor_url;
	} elsif(my $service = $self->service) {
		return $service;
	} else {
		return $self->script_url . '/status';
	}
};
