# $Id: Request.pm 35786 2011-10-17 15:25:44Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/Responder/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::Responder::Request;

use Aselect::UI::Request -self;

param request => sub { die "0030 Required request parameter 'request' not supplied\n" unless defined };
param signature => sub { die "0030 Required request parameter 'signature' not supplied\n" unless defined };

stub response;

sub check_signature {
	my $cfg = $self->cfg;

	my $requestor_id = $self->requestor_id;
	my $requestors = $cfg->requestors;

	my $requestor = $requestors->{$requestor_id}
		or die "0031 Unknown requestor '$requestor_id'\n";

	my $pubkey = $requestor->pubkey;

	return 0 unless $pubkey;

	my @params = map { $self->param($_) } @_;

	return 1 if $self->crypto->verify_signature($pubkey, $self->signature, @params);

	die "0031 Signature verification failed for '$requestor_id'\n";
}

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};
