# $Id: ValidateCAS.pm 33087 2010-11-19 12:11:41Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/ValidateCAS.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::ValidateCAS::Document;

use Xyzzy::Document -self;

sub response {
	my $req = $self->req;

	my $uid = $req->uid;

	my $answer = defined $uid ? "yes\n$uid\n" : "no\n\n";

	return new Xyzzy::Response(content => $answer);
}

package Aselect::ValidateCAS::Request;

use Aselect::Request -self;

param service => sub { die "Required request parameter 'service' not supplied\n" unless defined };
param ticket => sub { die "Required request parameter 'ticket' not supplied\n" unless defined };

const uid => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $self->crypto;

	my $ticket = $self->ticket;
	my $service = $self->service;

	my (undef, undef, $uid) = eval { $crypto->check_cas_token('ST', $service, $ticket, $cfg->credential_timeout) };
	warn "validate: $@" if $@;
	return $uid;
};

package Aselect::ValidateCAS;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::ValidateCAS::Request(cfg => $self, ctx => shift);
	my $doc = new Aselect::ValidateCAS::Document(req => $req);
	return $doc->response;
}
