# $Id: Session.pm 34055 2011-02-25 15:46:04Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Session.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Session::Request;

use Aselect::Login;
use Aselect::Login::Request -self;

param renew => sub { $_ = defined };

field uid => sub { shift->session; return };
field org => sub { shift->session; return };
field nag => sub { return 1 if super; shift->session; return };

field session => sub {
	my $self = shift;
	return undef if $self->renew;
	my $cookie = $self->cookie('session')
		or return undef;
	my (undef, undef, $uid, $org, $nag) =
		eval { $self->crypto->check_token('s', $cookie, $self->cfg->session_timeout) };
	if($@) {
		warn "session: $@";
		return undef;
	}
	$self->uid($uid);
	$self->org($org);
	$self->nag(1) if $nag;
	return $cookie;
};

sub sessioncookie { undef }

package Aselect::Session;

use Aselect::Handler -self;

use Aselect::Util;
use Time::HiRes qw(time);

field methods;

sub handle {
	my $req = new Aselect::Session::Request(cfg => $self, ctx => shift);
	return unless $req->session;
	my $doc = new Aselect::Login::Success(req => $req);
	return $doc->response;
}
