# $Id: Server.pm 32480 2010-09-16 14:43:53Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Server.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Server::Request;

use Aselect::Request -self;

param request => sub { die "0030 Required request parameter 'request' not supplied\n" unless defined };

package Aselect::Server;

use Aselect::Util;

use Aselect::Handler -self;

field 'requests';

sub handle {
	my $req = new Aselect::Server::Request(cfg => $self, ctx => shift);
	my $handler = $self->requests->{$req->request}
		or die "0030 Unknown request\n";
	return $handler->handle($req);
}
