# $Id: Responder.pm 32480 2010-09-16 14:43:53Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Responder.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Responder::Request;

use Aselect::Request -self;

param request => sub { die "0030 Required request parameter 'request' not supplied\n" unless defined };
param signature => sub { die "0030 Required request parameter 'signature' not supplied\n" unless defined };

stub response;

sub check_signature {
	my $cfg = $self->cfg;

	my $requestor_id = $self->requestor_id;
	my $requestors = $cfg->requestors;

	my $requestor = $requestors->{$requestor_id}
		or die "0031 Unknown requestor '$requestor_id'\n";

	my $pubkey = $requestor->pubkey
		or return 1;

	return 1 unless defined $pubkey;

	my @params = map { $self->param($_) } @_;

	$self->crypto->verify_signature($pubkey, $self->signature, @params)
		or die "0031 Signature verification failed for '$requestor_id'\n"
}

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

package Aselect::Responder::Document;

use Aselect::Util;

use Xyzzy::Document -self;

sub response {
	my $req = $self->req;
	my $id = $req->server_id;
	my $response = $req->response;
	
	my $res = new Xyzzy::Response;
	$res->content(aselect_join(%$response, 'a-select-server' => $id));
	return $res;
}
