# $Id: Login.pm 34104 2011-03-02 16:44:09Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Login.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Login::Request;

use Aselect::Util;
use Aselect::Request -self;

field request_timeout => sub { shift->cfg->request_timeout };
field org => sub { shift->cfg->organization };

param rid => sub {
	my $self = shift;
	if(defined) {
		my $crypto = $self->crypto;
		my (undef, undef, $origin, $id, $url) =
			eval { $crypto->check_token('r', $_, $self->cfg->request_timeout) };
		die $self->error('rid', $@) if $@;
		$self->requestor_origin($origin);
		$self->requestor_id($id);
		$self->requestor_url($url);
	} else {
		$self->requestor_origin(undef);
		$self->requestor_id(undef);
		$self->requestor_url(undef);
	}
};

param service => sub {
	die shift->error('service')
		if defined && /[^!-~]/;
};

field nag => sub { defined shift->param('warn') };

field requestor_origin => sub { shift->rid; return };
field requestor_id => sub { shift->rid; return };
field requestor_url => sub { shift->rid; return };

field success => undef;

field sessioncookie => sub {
	my $self = shift;
	my $uid = $self->uid or return;
	my $org = $self->org or return;
	my $nag = $self->nag ? 1 : 0;
	return scalar $self->crypto->create_token('s', $uid, $org, $nag);
};

field credentials => sub {
	my $self = shift;
	my $requestor_id = $self->requestor_id or return;
	my $uid = $self->uid or return;
	my $org = $self->org or return;
	return scalar $self->crypto->create_token('c', $requestor_id, $uid, $org);
};

field ticket => sub {
	my $self = shift;
	my $service = $self->service or return;
	my $uid = $self->uid or return;
	return scalar $self->crypto->create_cas_token('ST', $service, $uid);
};

field url => sub {
	my $self = shift;
	if(my $rid = $self->rid) {
		return aselect_url($self->requestor_url, {
				aselect_credentials => $self->credentials,
				rid => $self->rid,
				'a-select-server' => $self->server_id,
			});
	} elsif(my $service = $self->service) {
		return aselect_url($service, {ticket => $self->ticket});
	} else {
		return $self->script_url . '/';
	}
};

package Aselect::Login::Success;

use Aselect::Document -self;

sub build {
	$self->setDocumentElement($self->construct('login-success' =>
		['return-link' => $self->req->url]
	));
}

sub response {
	my $res = super;

	my $req = $self->req;

	my $url = $req->url;

	unless($req->nag) {
		$res->status(302);
		$res->setheader(Location => $url);
	}

	if(my $session = $req->sessioncookie) {
		my $cfg = $self->cfg;
		my $cookie = $self->bakecookie(session => $session);
		if(my $domain = $cfg->cookiedomain) {
			$cookie->setparameter(Domain => $domain);
		}
		$res->setcookie($cookie);
	}
	return $res;
}

package Aselect::Login;

use Aselect::Handler -self;

field methods;

sub handle {
	foreach my $method (@{$self->methods}) {
		my $res = $method->handle(@_);
		return $res if $res;
	}
	super;
}
