<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- overview of your credentials -->
	<xsl:template match="status" mode="title">
		<xsl:text>Status overview</xsl:text>
	</xsl:template>

	<xsl:template match="status">
		<p>You are currently logged in as <xsl:value-of select="uid"/> (<xsl:value-of select="organization"/>).</p>
		<form action="logout" method="post"><p>
			<input type="hidden" name="nonce" value="{nonce}"/>
			<button type="submit">Log out</button>
		</p></form>
		<xsl:apply-templates select="attributes"/>
		<xsl:apply-templates select="requestors"/>
	</xsl:template>

	<xsl:template match="attributes">
		<h2>Attributes for <xsl:value-of select="../app_id"/>:</h2>
		<table>
			<xsl:apply-templates select="attribute"/>
		</table>
	</xsl:template>

	<xsl:template match="attribute">
		<tr>
			<th><p><xsl:value-of select="name"/></p></th>
			<td><xsl:apply-templates select="values/value"/></td>
		</tr>
	</xsl:template>

	<xsl:template match="value">
		<p><xsl:value-of select="."/></p>
	</xsl:template>

	<xsl:template match="requestors">
		<h2>View the attributes disclosed to an application:</h2>
		<form action="." method="post">
			<select name="app_id">
				<option selected="selected" value="0">Select an Application ID…</option>
				<xsl:apply-templates select="requestor"/>
			</select>
			<button type="submit">View</button>
		</form>
	</xsl:template>

	<xsl:template match="requestor">
		<xsl:variable name="name" select="string()"/>
		<option value="{$name}"><xsl:value-of select="$name"/></option>
	</xsl:template>
</xsl:stylesheet>
