# $Id: SPNEGO.pm 35002 2011-06-09 15:13:06Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/SPNEGO.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO;

use Aselect::ASN1;
use Aselect::UI::SPNEGO::Request;
use Aselect::UI::SPNEGO::Success;
use Aselect::UI::SPNEGO::Authenticate;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::UI::SPNEGO::Request(cfg => $self, ctx => shift);
	return undef if $req->renew;
	return undef unless $req->feasible;
	my $doc = $req->login
		? new Aselect::UI::SPNEGO::Success(req => $req)
		: new Aselect::UI::SPNEGO::Authenticate(req => $req);
	return $doc->response;
}

const asn1 => sub {
	my $asn1 = new Aselect::ASN1;
	$asn1->configure(encoding => 'DER');
	$asn1->prepare(<<'EOT') or die $asn1->error;
		SPNEGO ::= [APPLICATION 0] SEQUENCE {
			spnego       MechType,
			negToken     NegotiationToken
		}

		NegotiationToken ::= CHOICE {
			negTokenInit    [0] EXPLICIT NegTokenInit,
			negTokenResp    [1] EXPLICIT NegTokenResp
		}

		MechType ::= OBJECT IDENTIFIER

		MechTypeList ::= SEQUENCE OF MechType

		NegTokenResp ::= SEQUENCE {
			negState       [0] EXPLICIT ENUMERATED,
			supportedMech  [1] EXPLICIT MechType      OPTIONAL,
			responseToken  [2] EXPLICIT OCTET STRING  OPTIONAL,
			mechListMIC    [3] EXPLICIT OCTET STRING  OPTIONAL
		}

		ContextFlags ::= BIT_STRING

		NegTokenInit ::= SEQUENCE {
			mechTypes      [0] EXPLICIT MechTypeList  OPTIONAL,
			reqFlags       [1] EXPLICIT ContextFlags  OPTIONAL,
			mechToken      [2] EXPLICIT OCTET STRING  OPTIONAL,
			mechListMIC    [3] EXPLICIT OCTET STRING  OPTIONAL
		}
EOT

	return $asn1->find('SPNEGO');
};
