# $Id: Authenticate.pm 35815 2011-10-20 13:03:54Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/SPNEGO/Authenticate.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::SPNEGO::Authenticate;

use Aselect::UI::Login -self;

sub build {
	$self->setDocumentElement($self->construct('spnego'));
}

sub response {
	my $res = super;
	$res->status(401);
	$res->addheader('WWW-Authenticate' => 'Negotiate');
	my $cookie = $self->bakecookie(spnego => 'fail');
	$cookie->expire('1y');
	$res->setcookie($cookie);
	return $res;
}
