# $Id: Request.pm 35814 2011-10-20 12:09:53Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Request;

use Aselect::UI::Login::Request -self;

param username => sub {
	return unless defined;
	s/\s+//g;
	$_ = lc;
};

param password;

param gateway => sub { $_ = defined };

field message => undef;

const login => sub {
	my $self = shift;

	return undef unless $self->lt;

	my $username = $self->username;
	my $password = $self->password;

	return undef unless $username && $password;

	my $uid = eval { $self->dir->authenticate($username, $password) };
	die $self->error('backend', $@, username => $username) if $@;
	unless(defined $uid) {
		$self->message('credentials');
		sleep(1);
	}

	return $uid;
};

field new_session => sub {
	my $self = shift;
	my $uid = $self->login;
	return $uid
		? $self->create_session($uid)
		: $self->SUPER::new_session;
};
