# $Id: Document.pm 35769 2011-10-13 18:37:39Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Password/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Password::Document;

use Aselect::UI::Login::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct(password =>
		[lt => $req->create_lt]
	);
	$self->setDocumentElement($root);

	if(my $username = $req->username || $req->uid) {
		$root->appendChild($self->construct(username => $username));
	}

	if(my $message = $req->message) {
		$root->appendChild($self->construct(message => $message));
	}
}

sub response {
	my $res = super;
	$res->addheader('Cache-Control' => 'no-store');
	return $res;
}
