# $Id: Success.pm 35773 2011-10-13 21:10:54Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Success.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Success;

use Aselect::UI::Login::Document -self;

sub build {
	$self->setDocumentElement($self->construct('login-success'));
}

sub response {
	my $res = super;

	my $req = $self->req;

	if($req->effective_warn eq 'false' || $req->nonce) {
		$res->status(302);
		$res->setheader('Location' => $req->cred_url);
		$res->addheader('Cache-Control' => 'no-store');
	}

	return $res;
}
