# $Id: Document.pm 35761 2011-10-12 18:45:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Document;

use Xyzzy::Util qw(iso8601);

use Xyzzy::Document::XHTML -self;

sub getStylesheet {
	my $lang = $self->req->lang
		or return super;
	my $file = shift;
	return super("$lang/$file", @_);
}

sub transform {
	return if $self->req->raw;
	return super;
}

sub build {
	$self->hook_next;
	my $cfg = $self->cfg;
	my $req = $self->req;
	my $root = $self->documentElement;

	$root->appendChild($self->construct(settings =>
		[warn => $req->new_warn],
		[spnego => $req->new_spnego],
	));

	$root->appendChild($self->construct(nonce => $req->create_nonce));

	if(my $uid = $req->uid) {
		my $exp = $req->new_session->expiration;

		my $session = $self->construct(session =>
			[uid => $uid],
			[organization => $cfg->organization],
			[start => iso8601(localtime($exp))],
			[end => iso8601(localtime($exp + $cfg->session_timeout))],
		);

		$root->appendChild($session);
	}

	my $name = $root->nodeName;
	$name =~ tr|:|/|;
	eval { $self->transform($name) };
	warn $@ if $@;
}

sub bakecookie {
	my $cookie = super;
	if(my $domain = $self->cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	return $cookie;
}

sub response {
	my $res = super;
	my $req = $self->req;

	my $session = $req->new_session->token;
	my $previous = $req->cur_session;
	unless($previous && $previous->token eq $session) {
		my $cookie = $self->bakecookie(session => $session);
		$cookie->setparameter(HttpOnly => 1);
		$res->setcookie($cookie);
	}

	# DOM/XSL system protects against XSS
	$res->setheader('X-XSS-Protection' => 0);

	$res->mimetype('application/xml')
		if $req->raw;

	return $res;
}
