# $Id: Error.pm 35496 2011-09-02 12:47:30Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Request/Error.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Request::Error;

use Aselect::UI::Document -self;

field type;
field args;

sub build {
	my $root = $self->construct('error', [code => $self->type]);
	$self->setDocumentElement($root);
	my $args = $self->args;
	if(%$args) {
		my $arglist = $self->construct('args');
		while(my ($key, $val) = each(%$args)) {
			$arglist->appendTextChild($key, "$val");
		}
		$root->appendChild($arglist);
	}
}
