# $Id: Success.pm 35590 2011-09-19 13:33:12Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Success.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Success;

use Aselect::UI::Document -self;

sub build {
	my $root = $self->construct('logout-success');
	$self->setDocumentElement($root);

	if(my $url = $self->req->back_url) {
		$root->appendChild($self->construct(url => $url));
	}
}

sub response {
	my $res = super;

	my $cfg = $self->cfg;
	my $cookie = $self->bakecookie(session => '');
	if(my $domain = $cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	$cookie->expire(0);
	$res->setcookie($cookie);

	return $res;
}
