# $Id: Request.pm 35588 2011-09-19 13:17:00Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Request;

use Aselect::UI::Request -self;

sub uid {
	my $session = $self->cur_session;
	return $session && $session->uid;
}

field new_session => sub {
	my $self = shift;
	return $self->logout_ok
		? $self->create_session
		: $self->SUPER::new_session;
};

sub logout_ok {
	return $self->uid && ($self->new_warn eq 'false' || $self->nonce);
}

sub confirmation_needed {
	return $self->uid && $self->new_warn eq 'true' && !$self->nonce;
}

param service => sub {
	die shift->error('service')
		if defined && !m{^https?://[!-~]+$};
};

field back_url => sub {
	return scalar shift->service;
};
