<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- please confirm your logout -->
	<xsl:template match="confirm-logout" mode="title">
		<xsl:text>Confirm logout</xsl:text>
	</xsl:template>

	<xsl:template match="confirm-logout">
		<form action="logout" method="post">
			<xsl:apply-templates select="nonce|url|warn"/>
			<p>If you did not intend to log out, simply click the back button or close this window.</p>
			<p><button type="submit"><strong>Log out</strong></button></p>
		</form>
	</xsl:template>

	<xsl:template match="nonce">
		<input type="hidden" name="nonce" value="{.}"/>
	</xsl:template>

	<xsl:template match="url">
		<input type="hidden" name="service" value="{.}"/>
	</xsl:template>

	<xsl:template match="warn">
		<input type="hidden" name="warn" value="{.}"/>
	</xsl:template>
</xsl:stylesheet>
