<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- overview of your attributes -->
	<xsl:template match="attributes" mode="title">
		<xsl:text>Attributes</xsl:text>
	</xsl:template>

	<xsl:template match="attributes">
		<xsl:choose>
			<xsl:when test="session">
				<xsl:apply-templates select="session/uid"/>
				<xsl:apply-templates select="session/organization"/>
				<xsl:apply-templates select="session/attributes"/>
				<xsl:apply-templates select="session/requestors"/>
			</xsl:when>
			<xsl:otherwise>
				<p>You are not currently logged in.</p>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="uid">
		<p>You are logged in as: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="organization">
		<p>Your organization is: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="session/attributes">
		<h2>Attributes for <xsl:value-of select="../app_id"/>:</h2>
		<table>
			<xsl:for-each select="attribute">
				<xsl:sort select="string(name)"/>
				<xsl:apply-templates select="."/>
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template match="attribute">
		<tr>
			<th><p><xsl:value-of select="name"/></p></th>
			<td>
				<xsl:for-each select="values/value">
					<xsl:sort select="string()"/>
					<xsl:apply-templates select="."/>
				</xsl:for-each>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="value">
		<p><xsl:value-of select="."/></p>
	</xsl:template>

	<xsl:template match="requestors">
		<h2>View the attributes disclosed to an application:</h2>
		<form action="attributes" method="post">
			<select name="app_id">
				<option selected="selected" value="0">Select an Application ID…</option>
				<xsl:for-each select="requestor">
					<xsl:sort select="string()"/>
					<xsl:apply-templates select="."/>
				</xsl:for-each>
			</select>
			<button type="submit"><strong>View</strong></button>
		</form>
	</xsl:template>

	<xsl:template match="requestor">
		<xsl:variable name="name" select="string()"/>
		<option value="{$name}"><xsl:value-of select="$name"/></option>
	</xsl:template>
</xsl:stylesheet>
