# $Id: Request.pm 35496 2011-09-02 12:47:30Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Request;

use Xyzzy::Util qw(parse_bool);
use Aselect::Util;
use Aselect::UI::Ticket;
use Aselect::UI::Request -self;

param rid => sub {
	my $self = shift;
	if(defined) {
		my $crypto = $self->crypto;
		my (undef, undef, $origin, $id, $url) =
			eval { $crypto->check_token('r', $_, $self->cfg->request_timeout) };
		die $self->error('rid', $@) if $@;
		$self->requestor_origin($origin);
		$self->requestor_id($id);
		$self->requestor_url($url);
	} else {
		$self->requestor_origin(undef);
		$self->requestor_id(undef);
		$self->requestor_url(undef);
	}
};

param service => sub {
	die shift->error('service')
		if defined && !m{^https?://[!-~]+$};
};

param lt => sub {
	my $self = shift;
	$_ = eval { $self->crypto->check_token('lt'.$self->cur_session->token, $_, $self->cfg->request_timeout); 1 };
};

sub create_lt {
	return scalar $self->crypto->create_token('lt'.$self->new_session->token);
}

sub nonce {
	return super || $self->lt;
}

field server_id => sub {
	my $self = shift;
	return $self->cfg->id || $self->virtual_host
};

param renew => sub { $_ = defined };

field requestor_origin => sub { shift->rid; return };
field requestor_id => sub { shift->rid; return };
field requestor_url => sub { shift->rid; return };

field credentials => sub {
	my $self = shift;
	my $requestor_id = $self->requestor_id or return;
	my $uid = $self->uid or return;
	return scalar $self->crypto->create_token('c', $requestor_id, $uid);
};

field ticket => sub {
	my $self = shift;
	my $service = $self->service or return;
	my $uid = $self->uid or return;
	return scalar $self->crypto->create_cas_token('ST', $service, $uid);
};

field url => sub {
	my $self = shift;
	if(my $rid = $self->rid) {
		return aselect_url($self->requestor_url, {
			rid => $rid,
			'a-select-server' => $self->server_id,
			aselect_credentials => $self->credentials,
		});
	} elsif(my $service = $self->service) {
		return aselect_url($service, {ticket => $self->ticket});
	} else {
		return $self->script_url . '/status';
	}
};

field bare_url => sub {
	my $self = shift;
	if(my $requestor_url = $self->requestor_url) {
		return $requestor_url;
	} elsif(my $service = $self->service) {
		return $service;
	} else {
		return $self->script_url . '/status';
	}
};
