# $Id: Success.pm 35496 2011-09-02 12:47:30Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Success.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Success;

use Aselect::UI::Document -self;

sub build {
	$self->setDocumentElement($self->construct('logout-success',
		['return-link', $self->req->url]
	));
}

sub response {
	my $res = super;

	my $cfg = $self->cfg;
	my $cookie = $self->bakecookie(session => '');
	if(my $domain = $cfg->cookiedomain) {
		$cookie->setparameter(Domain => $domain);
	}
	$cookie->expire(0);
	$res->setcookie($cookie);

	return $res;
}
