# $Id: Document.pm 35174 2011-07-05 13:22:23Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Giveup/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Giveup::Document;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;
	$self->setDocumentElement($self->construct(giveup =>
		[nonce => $req->create_nonce],
		[url => $req->url]
	));
}

sub response {
	my $res = super;

	my $req = $self->req;

	if($req->new_warn eq 'false') {
		$res->status(302);
		$res->setheader(Location => $req->url);
	}

	return $res;
}
