# $Id: Server.pm 34999 2011-06-09 09:30:44Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/WS/Server.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::WS::Server;

use Aselect::WS::Responder::Document;

use Aselect::Handler -self;

field 'requests';

sub handle {
	my $req = new Aselect::WS::Server::Request(cfg => $self, ctx => shift);
	my $res = eval {
		my $handler = $self->requests->{$req->request}
			or die "0030 Unknown request\n";
		$handler->handle($req);
	};
	if($@) {
		my $exc = $@;
		die $exc if ref $exc || $exc !~ /^(\d\d\d\d)(?: (.*))?$/;
		my $err = new Aselect::WS::Server::Error(cfg => $self, ctx => $req, code => $1, message => $2);
		my $doc = new Aselect::WS::Responder::Document(req => $err);
		die $doc->response;
	}
	return $res;
}
