<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
		xmlns="http://www.w3.org/1999/xhtml"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:import href="common.xsl"/>

	<!-- overview of your credentials -->
	<xsl:template match="status" mode="title">
		<xsl:text>Status overview</xsl:text>
	</xsl:template>

	<xsl:template match="status">
		<xsl:choose>
			<xsl:when test="session">
				<xsl:apply-templates select="session/uid"/>
				<xsl:apply-templates select="session/organization"/>
				<xsl:apply-templates select="session/start"/>
				<xsl:apply-templates select="session/end"/>
				<form action="logout" method="post"><p>
					<input type="hidden" name="nonce" value="{nonce}"/>
					<button type="submit">Log out</button>
				</p></form>
				<xsl:apply-templates select="session/attributes"/>
				<xsl:apply-templates select="session/requestors"/>
			</xsl:when>
			<xsl:otherwise>
				<p>You are not currently logged in.</p>
				<form action='login' method='get'>
					<p><button type='submit'>Log in</button></p>
				</form>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates select="warn"/>
		<xsl:apply-templates select="spnego"/>
	</xsl:template>

	<xsl:template match="warn[.='true']">
		<p>Warnings are currently enabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<input type="hidden" name="warn" value="false"/>
			<button type="submit">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="warn">
		<p>Warnings are currently disabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<input type="hidden" name="warn" value="true"/>
			<button type="submit">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='ok']">
		<p>Domain logon is is currently enabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='fail']">
		<p>Domain logon is is currently disabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='enabled']">
		<p>Domain logon is is currently force enabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego[.='disabled']">
		<p>Domain logon is is currently force disabled. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="spnego">
		<p>Domain logon is is currently autodetected. <form action="." method="post" style="display: inline">
			<input type="hidden" name="nonce" value="{../nonce}"/>
			<button type="submit" name="spnego" value="disabled">Disable</button>
			<button type="submit" name="spnego" value="enabled">Enable</button>
		</form></p>
	</xsl:template>

	<xsl:template match="uid">
		<p>You are logged in as: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="organization">
		<p>Your organization is: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="start">
		<p>Your session started at: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="end">
		<p>Your session ends at: <xsl:value-of select="."/>.</p>
	</xsl:template>

	<xsl:template match="attributes">
		<h2>Attributes for <xsl:value-of select="../app_id"/>:</h2>
		<table>
			<xsl:for-each select="attribute">
				<xsl:sort select="string(name)"/>
				<xsl:apply-templates select="."/>
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template match="attribute">
		<tr>
			<th><p><xsl:value-of select="name"/></p></th>
			<td>
				<xsl:for-each select="values/value">
					<xsl:sort select="string()"/>
					<xsl:apply-templates select="."/>
				</xsl:for-each>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="value">
		<p><xsl:value-of select="."/></p>
	</xsl:template>

	<xsl:template match="requestors">
		<h2>View the attributes disclosed to an application:</h2>
		<form action="." method="post">
			<select name="app_id">
				<option selected="selected" value="0">Select an Application ID…</option>
				<xsl:for-each select="requestor">
					<xsl:sort select="string()"/>
					<xsl:apply-templates select="."/>
				</xsl:for-each>
			</select>
			<button type="submit">View</button>
		</form>
	</xsl:template>

	<xsl:template match="requestor">
		<xsl:variable name="name" select="string()"/>
		<option value="{$name}"><xsl:value-of select="$name"/></option>
	</xsl:template>
</xsl:stylesheet>
