use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Request;

use Clarity -self;

use Scalar::Util qw(reftype);

use Xyzzy::Response;
use Xyzzy::Status;

field ctx;
field cfg => sub { shift->ctx->cfg };

our @EXPORT_BASE = qw(resource param);

sub error {
	my $status = new Xyzzy::Status(@_);
	return $status->response;
}

sub resource(&) {
	my $name = shift;
	my $package = caller;
	Clarity::Internals::field($package, $name, sub { shift->cfg->$name() });
}

sub param(*@) {
	my $name = shift;
	return $name->ctx->param(@_) if ref $name;
	my $package = caller;
	my $init;
	my $initcode = 'return $self->{$name} = $self->param($name)';
	if(@_) {
		$init = shift;
		if(ref $init) {
			if(reftype $init eq 'CODE') {
				$initcode = '
					undef $self->{$name};
					local $_ = $self->param($name);
					$init->($self, $name, $package, $_);
					return $self->{$name} = $_';
					#	=> sub { die unless defined }
					#	=> sub { die unless $_ }
					#	=> sub { die if /\W/ }
					#	=> sub { $_ ||= "none" }
					#	=> sub { $_ //= "none" }
					#	=> sub { $_ = lc }
					#	=> sub { s/bob/robert/g if defined }
			} else {
				$init = Clarity::Factory::factory($init);
				$initcode .= ' // $init->()';
			}
		} else {
			$initcode .= ' // $init';
		}
	}
	my $code = "
		package $package;
		sub $name {
			my \$self = shift;
			return \$self->{\$name} if exists \$self->{\$name};
			$initcode;
		}
	";
	my $err = do { local $@; eval $code; $@ };
	confess($err) if $err;
}

sub DESTROY {} # don't try to autoload this

sub AUTOLOAD {
	my $sub = our $AUTOLOAD;
	my $off = rindex($sub, '::');
	confess("no package name in '$sub'")
		if $off == -1;
	my $pkg = substr($sub, 0, $off + 2, '');
	my $code = "sub $sub { my \$self = shift; \$self->ctx->$sub(\@_) }";
	my $err = do { local $@; eval $code; $@ };
	confess($err) if $err;
	return $self->ctx->$sub(@_);
}
