use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Database;

use Xyzzy::Database::Request;
use DBI;

use Xyzzy::Handler -self;

field db_dsn => sub { shift->cfg->db_dsn };
field db_user => sub { shift->cfg->db_user };
field db_pass => sub { shift->cfg->db_pass };
field db_options => sub { shift->cfg->db_options };

field conn => sub {
	my $self = shift;
	return DBI->connect($self->db_dsn, $self->db_user, $self->db_pass, $self->db_options);
};

sub handle {
	my $req = new Xyzzy::Database::Request(ctx => shift, cfg => $self);
	if(my $db = $self->{conn}) {
		delete $self->{conn} unless $db->ping;
	}
	my $res = eval { super($req) };
	my $db = $self->{conn};
	if(defined $res) {
		if($db && $db->{Executed}) {
			$db->commit;
		}
	} else {
		if($db && $db->{Executed}) {
			local $@;
			eval { $db->rollback };
			warn $@ if $@;
		}
		die $@ if $@;
	}
	return $res;
}
