package Xyzzy::Crypto::Config;

use Xyzzy -self;

use Digest::SHA qw(sha256);
use Xyzzy::Util qw(parse_time);

field cryptosecret => sub { die "no CryptoSecret configured\n" };
sub set_cryptosecret; *set_cryptosecret = \&cryptosecret;

field cryptoclockjitter => 0;
sub set_cryptoclockjitter {
	$self->cryptoclockjitter(parse_time(shift));
}

# 512 bits should be enough for anyone
field cryptoseedbytes => 64;
sub set_cryptoseedbytes; *set_cryptoseedbytes = \&cryptoseedbytes;

# http://www.2uo.de/myths-about-urandom/
field cryptoseedsource => '/dev/urandom';
sub set_cryptoseedsource; *set_cryptoseedsource = \&cryptoseedsource;
