use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::CAS::Config;

use Xyzzy::Util qw(parse_time parse_bool);

my $have_curl;
my $have_curl_feedback;
BEGIN {
	$have_curl = eval "use WWW::Curl::Easy; 1";
	$have_curl_feedback = $@;
}

use Xyzzy -self;
use Xyzzy::Crypto::Config -mixin;

field cas_base_url => sub { die "Missing configuration value CASbaseURL\n" };
field cas_login_url => sub { shift->cas_base_url . '/login' };
field cas_validate_url => sub { shift->cas_base_url . '/validate' };
field cas_domain => undef;
field cas_force_domain => undef;
field cas_force_https => !undef;
field cas_use_curl => $have_curl;

field session_timeout => 36000;
field request_timeout => 3600;

*set_casbaseurl = *cas_base_url;
*set_casloginurl = *cas_login_url;
*set_casvalidateurl = *cas_validate_url;
*set_casdomain = *cas_domain;

sub set_casforcedomain { $self->cas_force_domain(parse_bool(shift)) }
sub set_casforcehttps { $self->cas_force_https(parse_bool(shift)) }
sub set_casusecurl {
	my $value = parse_bool(shift);
	die "CURL requested but WWW::Curl::Easy not available:\n$have_curl_feedback"
		if $value && !$have_curl;
	$self->cas_use_curl($value);
}

sub set_sessiontimeout { $self->session_timeout(parse_time(shift)) }
sub set_requesttimeout { $self->request_timeout(parse_time(shift)) }
