use utf8;
use strict;
use warnings FATAL => 'all';

package Xyzzy::Crypto::Config;

use Digest::SHA qw(sha256);
use Xyzzy::Util qw(parse_time);

use Xyzzy -self;

field cryptosecret => sub { die "no CryptoSecret configured\n" };
*set_cryptosecret = *cryptosecret;

field cryptoclockjitter => 0;
sub set_cryptoclockjitter {
	$self->cryptoclockjitter(parse_time(shift));
}

# 512 bits should be enough for anyone
field cryptoseedbytes => 64;
*set_cryptoseedbytes = *cryptoseedbytes;

# http://www.2uo.de/myths-about-urandom/
field cryptoseedsource => '/dev/urandom';
*set_cryptoseedsource = *cryptoseedsource;
