#!/usr/bin/perl

use Modern::Perl;

use lib 'tools/lib';
use Module::Build::SetVersion;

my $build = Module::Build::SetVersion->new(
    dist_name           => 'uvt-noc-cacti-plugins',
    dist_version        => '1.1.2',
    dist_abstract       => 'Plugins for Cacti as used by Tilburg University - LIS Networks',
    module_name         => 'UvT::NOC::Cacti::Plugins',
    dist_author         => 'Jurgen van den Hurk <jvdhurk@tilburguniversity.edu',
    license             => 'perl',
    create_makefile_pl  => 'traditional',

    build_requires                  => {
        'Module::Build'             => '0.28',
        'Module::Build::SetVersion' => '1.00',
        'Readonly'                  => '0',
        'Pod::Simple'               => '3.06',
    },

    requires           => {
        'Pod::Usage'   => '1.26',
        'Getopt::Long' => '2.39',
        'Net::SNMP'    => '6.0.1',
    },
);

$build->create_build_script;
