#! /usr/bin/perl

# $Id: uvt-email-template.pl 43671 2015-07-28 15:14:37Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/uvt-email-template/bin/uvt-email-template.pl $

use strict;
use warnings FATAL => 'all';
use utf8;

use File::Basename qw(dirname);

our $PACKAGE //= 'uvt-email-template';
our $pkgdatadir //= our $datadir ? "$datadir/$PACKAGE" : 'share';

use UvT::Email::Template;

my $imagepath = [dirname($ARGV[0]), $pkgdatadir];
$imagepath = [map { $_ || @$imagepath } split(qr{:}, $ENV{IMAGEPATH}, -1) ]
	if exists $ENV{IMAGEPATH};

my $e = new UvT::Email::Template(htmltemplate => "$pkgdatadir/html.xsl", imagepath => $imagepath);

print $e->format(@ARGV);

__END__

=pod

=encoding utf8

=head1 NAME

uvt-email-template - Convert an XML formatted message to RFC2822

=head1 SYNOPSIS

 uvt-email-template foo.xml Subject "hello world" To "bob@example.com"

=head1 ENVIRONMENT

The IMAGEPATH environment variable is a colon-separated list of directories
for uvt-email-template to look when including image files. Any empty
elements are replaced by the default value (which is the base directory of
the supplied XML followed by the image directory shipped by the package).

=head1 AUTHOR

Wessel Dankers <wsl@uvt.nl>

=head1 COPYRIGHT

Copyright © 2013,2015 Tilburg University.

Licensed under the GPLv3 license or (at your option) any later version.
